/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.arsenal.item;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import dev.doctor4t.arsenal.cca.ArsenalComponents;
import dev.doctor4t.arsenal.cca.WeaponOwnerComponent;
import dev.doctor4t.arsenal.entity.BloodScytheEntity;
import dev.doctor4t.arsenal.index.ArsenalCosmetics;
import dev.doctor4t.arsenal.index.ArsenalDamageTypes;
import dev.doctor4t.arsenal.index.ArsenalEnchantments;
import dev.doctor4t.arsenal.index.ArsenalSounds;
import dev.doctor4t.arsenal.item.ArsenalWeaponItem;
import dev.doctor4t.arsenal.util.SweepParticleUtil;
import dev.doctor4t.ratatouille.item.CustomHitParticleItem;
import dev.doctor4t.ratatouille.item.CustomHitSoundItem;
import dev.doctor4t.ratatouille.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ScytheItem
extends class_1766
implements CustomHitParticleItem,
CustomHitSoundItem,
ArsenalWeaponItem {
    private static final class_1322 REACH_MODIFIER = new class_1322(UUID.fromString("911af262-067d-4da2-854c-20f03cc2dd8b"), "Weapon modifier", 0.5, class_1322.class_1323.field_6328);

    public ScytheItem(class_1832 material, float damage, float speed, class_1792.class_1793 settings) {
        super(damage, speed, material, class_3481.field_33714, settings);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        LinkedHashMultimap map = LinkedHashMultimap.create((Multimap)super.method_7844(slot));
        if (slot == class_1304.field_6173) {
            map.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)REACH_MODIFIER);
        }
        return map;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 blockStateClicked = context.method_8045().method_8320(context.method_8037());
        class_1657 user = context.method_8036();
        if (user != null && user.method_5715() && (blockStateClicked.method_26164(class_3481.field_15486) || blockStateClicked.method_27852(class_2246.field_16329)) && context.method_8045().field_9236) {
            if (ArsenalCosmetics.isSupporter(user.method_5667())) {
                WeaponOwnerComponent weaponOwnerComponent = (WeaponOwnerComponent)ArsenalComponents.WEAPON_OWNER_COMPONENT.get((Object)user.method_5998(context.method_20287()));
                Skin currentSkin = Skin.fromString(ArsenalCosmetics.getSkin(context.method_8041()));
                if (currentSkin == null) {
                    currentSkin = Skin.DEFAULT;
                }
                ArsenalCosmetics.setSkin(weaponOwnerComponent.getOwner(), context.method_8041(), Skin.getNext(currentSkin).getName());
                context.method_8036().method_5783(class_3417.field_22463, 0.5f, 1.0f);
                return class_1269.field_5812;
            }
            if (context.method_8045().field_9236) {
                user.method_43496((class_2561)class_2561.method_43471((String)"tooltip.supporter_only").method_27694(style -> style.method_36139(0xCC0000)));
                context.method_8036().method_5783(class_3417.field_15239, 0.5f, 1.0f);
            }
            return class_1269.field_5814;
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (class_1890.method_8203((class_1887)ArsenalEnchantments.SPEWING, (class_1309)player) > 0) {
            float f = 1.0f;
            if (!world.field_9236) {
                class_1293 statusEffectInstance2;
                BloodScytheEntity bloodScythe = new BloodScytheEntity(world, (class_1309)player);
                bloodScythe.method_7432((class_1297)player);
                bloodScythe.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, f * 3.0f, 1.0f);
                bloodScythe.method_7438(bloodScythe.method_7448());
                player.method_5998(hand).method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                bloodScythe.field_7572 = class_1665.class_1666.field_7594;
                ArrayList<class_1293> statusEffectsHalved = new ArrayList<class_1293>();
                float absorption = player.method_6067();
                for (class_1293 statusEffect : player.method_6026()) {
                    class_1293 statusHalved = new class_1293(statusEffect.method_5579(), statusEffect.method_5584() / 2, statusEffect.method_5578(), statusEffect.method_5591(), statusEffect.method_5581(), statusEffect.method_5592());
                    bloodScythe.addEffect(statusHalved);
                    statusEffectsHalved.add(statusHalved);
                }
                player.method_6012();
                for (class_1293 statusEffectInstance2 : statusEffectsHalved) {
                    player.method_6092(statusEffectInstance2);
                }
                player.method_6073(absorption);
                player.method_5643(world.method_48963().method_48795(ArsenalDamageTypes.SPEWING), 3.0f);
                player.method_7357().method_7906((class_1792)this, 20);
                world.method_8649((class_1297)bloodScythe);
                statusEffectInstance2 = player.method_37908();
                if (statusEffectInstance2 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)statusEffectInstance2;
                    Skin skin = Skin.DEFAULT;
                    Skin toSkin = Skin.fromString(ArsenalCosmetics.getSkin(player.method_6047()));
                    if (toSkin != null) {
                        skin = toSkin;
                    }
                    class_3545 colorPair = new class_3545((Object)skin.color, (Object)skin.shadowColor);
                    SweepParticleUtil.sendSweepPacketToClient(serverWorld, (class_3545<Integer, Integer>)colorPair, player.method_23317() + (double)(-class_3532.method_15374((float)((float)((double)player.method_36454() * (Math.PI / 180))))), player.method_23323(0.5), player.method_23321() + (double)class_3532.method_15362((float)((float)((double)player.method_36454() * (Math.PI / 180)))));
                }
            }
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ArsenalSounds.ITEM_SCYTHE_SPEWING, class_3419.field_15248, 1.0f, 1.0f);
            return class_1271.method_22427((Object)player.method_5998(hand));
        }
        return super.method_7836(world, player, hand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Skin skin = Skin.fromString(ArsenalCosmetics.getSkin(stack));
        if (skin != null && skin != Skin.DEFAULT) {
            tooltip.add((class_2561)class_2561.method_43470((String)(skin.tooltipName != null ? skin.tooltipName : TextUtils.formatValueString((String)skin.getName()))).method_27694(style -> style.method_36139(skin.color)));
            if (skin.lore != null) {
                if (class_437.method_25442()) {
                    class_5250 translatable = class_2561.method_43471((String)skin.lore);
                    for (String line : translatable.getString().split("\n")) {
                        tooltip.add((class_2561)class_2561.method_43470((String)line).method_27694(style -> style.method_10977(class_124.field_1063)));
                    }
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.arsenal.hidden").method_27694(style -> style.method_10977(class_124.field_1063)));
                }
            }
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void spawnHitParticles(class_1657 player) {
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            Skin skin = Skin.DEFAULT;
            Skin toSkin = Skin.fromString(ArsenalCosmetics.getSkin(player.method_6047()));
            if (toSkin != null) {
                skin = toSkin;
            }
            class_3545 colorPair = new class_3545((Object)skin.color, (Object)skin.shadowColor);
            SweepParticleUtil.sendSweepPacketToClient(serverWorld, (class_3545<Integer, Integer>)colorPair, player.method_23317() + (double)(-class_3532.method_15374((float)((float)((double)player.method_36454() * (Math.PI / 180))))), player.method_23323(0.5), player.method_23321() + (double)class_3532.method_15362((float)((float)((double)player.method_36454() * (Math.PI / 180)))));
        }
    }

    public void playHitSound(class_1657 player) {
        player.method_5783(ArsenalSounds.ITEM_SCYTHE_HIT, 1.0f, (float)(1.0 + player.method_6051().method_43059() / 10.0));
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_7337();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            WeaponOwnerComponent weaponOwnerComponent = (WeaponOwnerComponent)ArsenalComponents.WEAPON_OWNER_COMPONENT.get((Object)stack);
            weaponOwnerComponent.setOwner(player.method_5667());
        }
    }

    public static enum Skin {
        DEFAULT(-2500135, -8419195, null, null),
        CLOWN(-2554848, -7601120, null, "tooltip.arsenal.scythe_clown"),
        CARRION(-1450056, -6455186, null, null),
        GILDED(-934822, -1931724, null, null),
        ROZE(-4784026, -9369271, null, null),
        FOLLY(-65446, -4456379, "Folly Tree Branch", null),
        SCISSORS(-4607569, -9475985, null, null);

        public final int color;
        public final int shadowColor;
        @Nullable
        public final String lore;
        @Nullable
        public final String tooltipName;

        private Skin(@Nullable int color, @Nullable int shadowColor, String tooltipName, String lore) {
            this.color = color;
            this.shadowColor = shadowColor;
            this.lore = lore;
            this.tooltipName = tooltipName;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Nullable
        public static Skin fromString(String name) {
            for (Skin skin : Skin.values()) {
                if (!skin.getName().equalsIgnoreCase(name)) continue;
                return skin;
            }
            return null;
        }

        public static Skin getNext(Skin skin) {
            Skin[] values = Skin.values();
            return values[(skin.ordinal() + 1) % values.length];
        }
    }
}

